unit Unit1;
//  ,       
interface

uses
  Windows, Classes, Controls, Messages, SysUtils, Variants, Graphics,
  Forms, Dialogs, WinBeep, MemDump2, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    ListBox1: TListBox;
    Edit3: TEdit;
    Timer1: TTimer;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
// ---------------------------------------------------------------------------
implementation
{$R *.dfm}
// ---------------------------------------------------------------------------
type TSmClient = class(TThread)
private
  fMark     : string[3];    //    
  fBusy     : boolean;      //    
  fPause    : word;         //    
  fID       : string[16];   //  ThreadID
public
  constructor Create;
  procedure Execute(); override;
  property  Busy  : boolean read fBusy;
  property  Pause : word read fPause write fPause;
end;

// ---------------------------------------------------------------------------
type TSmC =record
  SmClient   : TSmClient;   //   
  SmC1     : cardinal;      // 
  SmC2     : integer;       // 
end;

type TArrTSmC = array[0..3] of TSmC;

var ArrTSmC : TArrTSmC;

// --------------------------------------------------------------------------
//                   TSmClient
// --------------------------------------------------------------------------
constructor TSmClient.Create;
begin
   inherited Create(True);           //    Suspended
   fMark  := '>>>';
   fBusy  := False;
   fPause := 10;
   FillChar(fID, SizeOf(fID), $20);  //  
   fID := IntToStr(ThreadID);        //    
end;

procedure TSmClient.Execute;
begin
   repeat
       fBusy := True;
       sleep(fPause);
       fBusy := False;
       self.Suspend;
   until Terminated;
end;

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// 03.11.2015
//    - 
procedure ShowSmClientStatus(Index : integer; RqEd1, RqEd2 : TEdit);
begin
if (Index >= 0) and (Index < length(ArrTSmC))
   then begin
       if not ArrTSmC[Index].SmClient.Busy
       then begin
           RqEd1.Font.Color := clBlue;
           RqEd1.Font.Style := [];
           RqEd1.Text := ' ';
           RqEd2.Text := '';
       end
       else begin
           RqEd1.Font.Color := clRed;
           RqEd1.Font.Style := [fsBold];
           RqEd1.Text := '';
           RqEd2.Text := IntToStr(ArrTSmC[Index].SmClient.Pause)
                      + ' msec';
       end;
   end
   else begin
      RqEd1.Text := '';
      RqEd2.Text := '';
   end;
end;

// --------------------------------------------------------------------------
// 02.11.2015
//  
procedure TForm1.Button1Click(Sender: TObject);
var n : integer;
begin
   Memo1.Clear;
   for n:=0 to length(ArrTSmC)-1
   do begin
     if not Assigned(ArrTSmC[n].SmClient)
     then begin
        ArrTSmC[n].SmClient := TSmClient.Create;
        ListBox1.Items.Add(IntToStr(ArrTSmC[n].SmClient.ThreadID));
        //   
        //   EXECUTE
        // Set FreeOnTerminate to true if you dont want to explicitly
        // destroy threads after they finish executing. When FreeOnTerminate
        // is false, the thread object must be explicitly destroyed in
        // application code.
        ArrTSmC[n].SmClient.FreeOnTerminate := True;
     end;
   end;
end;

// ---------------------------------------------------------------------------
// 02.11.2015
//   
procedure TForm1.ListBox1Click(Sender: TObject);
var n     : integer;
    wSize : integer;
begin
   n := ListBox1.ItemIndex;
   if (n < length(ArrTSmC))
   then begin
      Memo1.Clear;
      Edit2.Text := '';
      if Assigned(ArrTSmC[n].SmClient)
      then begin
        //  
        wSize := ArrTSmC[n].SmClient.InstanceSize;
        MemToHexAndCharDump (ArrTSmC[n].SmClient, wSize, Memo1, True);
        //  
        Edit2.Text := IntToStr(wSize);
        //   
        ShowSmClientStatus(n, Edit1, Edit3);
      end;
      ListBox1.Repaint;
   end;
end;

// ---------------------------------------------------------------------------
// 02.11.2015
//  
procedure TForm1.Button2Click(Sender: TObject);
var n : integer;
begin
    n := ListBox1.ItemIndex;
    if (n >= 0) and (n < length(ArrTSmC))
    then begin
       if Assigned(ArrTSmC[n].SmClient)
       then begin
         if (not ArrTSmC[n].SmClient.Busy) and (ArrTSmC[n].SmClient.Suspended)
         then begin
              ArrTSmC[n].SmClient.Pause := 5000 + 10 * random(1000);
              ArrTSmC[n].SmClient.Resume;
         end;
       end;
    end;
end;

// ---------------------------------------------------------------------------
// 02.11.2015
//      
procedure TForm1.Button3Click(Sender: TObject);
var n     : integer;
begin
   Memo1.Clear;
   Edit1.Text := '';
   Edit2.Text := '';
   for n:=0 to length(ArrTSmC)-1
   do begin
     if Assigned(ArrTSmC[n].SmClient)
     then begin
        ArrTSmC[n].SmClient.Terminate;
        if ArrTSmC[n].SmClient.Suspended then ArrTSmC[n].SmClient.Resume;
        //      Execute
        sleep(20);
        //       
        if not ArrTSmC[n].SmClient.FreeOnTerminate
        then ArrTSmC[n].SmClient.Destroy;
        ArrTSmC[n].SmClient := nil;
     end;
   end;
   ListBox1.Clear;
   sleep(40);
end;

// ---------------------------------------------------------------------------
// 03.11.2015
//   
procedure TForm1.Timer1Timer(Sender: TObject);
var n : integer;
begin
   ListBox1.Repaint;
   n := ListBox1.ItemIndex;
   ShowSmClientStatus(n, Edit1, Edit3);
end;

// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
// 03.11.2015
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
   ListBox1.Style       := lbOwnerDrawFixed;
   ListBox1.MultiSelect := False;
   ListBox1.ItemHeight  := 16;
end;

// ---------------------------------------------------------------------------
// 03.11.2015
//   ListBox -   Item
procedure TForm1.ListBox1DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
const PicLen   = 16;              //    
      PicLeft  = 4;               //   
      Delim    = 10;              //   
      //     
      TxtLeft  = PicLeft + PicLen +  Delim;
begin
   with (Control as TListBox) do
   begin
      if Style <> lbOwnerDrawFixed then Exit;
      //    
      Canvas.Pen.Style   := psClear;

      Canvas.Brush.Style := bsSolid;
      Canvas.Brush.Color := Color;
      Canvas.Rectangle(Rect.Left, Rect.Top - 1,
                       Rect.Right, Rect.Bottom + 1);
      //         ArrTSmC
      Canvas.Pen.Style   := psSolid;
      Canvas.Pen.Color   := clBlue;
      if (Index >= 0) and (Index < Length(ArrTSmC))
      then begin
         if ArrTSmC[Index].SmClient.Busy
         then Canvas.Brush.Color := clYellow
         else Canvas.Brush.Color := clLime;
      end
      else Canvas.Brush.Color := clRed;
      //    ( )
      Canvas.Rectangle(Rect.Left + PicLeft, Rect.Top + 1,
                       Rect.Left + PicLeft + PicLen, Rect.Bottom - 1);
      //      
      Canvas.Pen.Style   := psClear;
      if Selected[Index]
      then begin
         Canvas.Font.Style := [fsBold];
         Canvas.Font.Color := clBlue;
      end
      else begin
         Canvas.Font.Style := [];
         Canvas.Font.Color := clBlack;
      end;
      Canvas.Brush.Style := bsClear;
      Canvas.TextOut(Rect.Left + TxtLeft, Rect.Top, Items.Strings[Index]);
   end;
end;
// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
end.
